/*
 * Sketch: BT24 Rename
 * Author: vmihas
 * Version: 1.0
 * Description: A sketch to rename the BlueTooth module DX-BT24.
 */

void setup() {
  Serial.begin(9600);
  pinMode(13, OUTPUT);
}

String waitForEnter() {
  while (Serial.available()) {
    Serial.read();
  }
  while (!Serial.available()) ;
  String input = Serial.readStringUntil('\n');
  input.trim();
  return input;
}

void waitForModuleConnection() {
  Serial.println("Βάλε το διακόπτη ΒΤ στη θέση ΟΝ για να συνδεθεί με το R2...");
  bool moduleReady = false;
  while (!moduleReady) {
    Serial.println("AT");
    String response = Serial.readStringUntil('\n');
    if (response.indexOf("OK") != -1) {
      moduleReady = true;
      Serial.println("Module συνδεδεμένο!");
    } else {
      Serial.println("Αναμονή σύνδεσης module... Βάλε το διακόπτη ΒΤ στη θέση ΟΝ.");
      delay(1000);
    }
  }
}

void loop() {
  Serial.println("Βάλε το διακόπτη ΒΤ στη θέση OFF και τοποθέτησε το BT module στο R2. Στη συνέχεια πάτησε ENTER:");
  waitForEnter();

  waitForModuleConnection();
  delay(500);

  Serial.println("AT+NAME");
  String response = Serial.readStringUntil('\n');

  if (response.length() == 0 || response.indexOf("+NAME") == -1) {
    Serial.println("Δε βρέθηκε BT module ή υπάρχει σύνδεση Bluetooth με κάποια συσκευή (τάμπλετ)");
    return;
  }

  String currentName = response.substring(response.indexOf('=') + 1);
  currentName.trim();
  Serial.println("Τρέχον όνομα: " + currentName);

  Serial.println("Βάλε το διακόπτη ΒΤ στη θέση ΟFF και δώσε νέο όνομα για το BT module, μετά ENTER:");
  String newName = waitForEnter();

  if (newName.length() == 0) {
    Serial.println("Δεν δόθηκε όνομα. Η διαδικασία ακυρώθηκε.");
    return;
  }

  waitForModuleConnection();
  delay(500);

  Serial.println("AT+NAME" + newName);
  Serial.readStringUntil('\n'); // Ανάγνωση +NAME=newName
  Serial.readStringUntil('\n'); // Ανάγνωση OK
  
  delay(500);  
  
  Serial.println("AT+RESET");
  Serial.readStringUntil('\n'); // Ανάγνωση +RESET
  Serial.readStringUntil('\n'); // Ανάγνωση OK

  Serial.println("AT+NAME");
  response = Serial.readStringUntil('\n');
  
  if (response.indexOf(newName) != -1) {
    Serial.println("Το όνομα του ΒΤ module άλλαξε με επιτυχία!");
    Serial.println("Νέο όνομα: " + newName);
    
    // Sound Notification
    tone(13, 440, 250);
    delay(250);
    tone(13, 880, 250);
    delay(250);
  } else {
    Serial.println("Αποτυχία αλλαγής ονόματος!");
    return;
  }

  Serial.println("Βάλε το διακόπτη ΒΤ στη θέση ΟFF και αφαίρεσε το ΒΤ module από το R2.");
  Serial.println("Πάτησε Enter για να αλλάξεις το όνομα και άλλου module:");
  waitForEnter();
}
