# Polytech R2 kit - MindPlus Extension (offline mode)


![](./arduinoC/_images/featured.png)

Το έργο αυτό είναι είναι extension για την εφαρμογή [Mind+](https://mindplus.cc/) το οποίο "μαζεύει" σε ένα σετ εντολών όλες τις λειτουργίες του κιτ που εναλλακτικά θα απαιτούσαν πολλά πρόσθετα για να λειτουργήσουν. 

Σκοπός του extension είναι να "κρυφτεί" η πολυπλοκότητα της διαδικασίας ενσωμάτωσης διαφορετικών βιβλιοθηκών Arduino C ώστε να λειτουργήσουν όλα τα πρόσθετα που περιέχει το κιτ. Για παράδειγμα ο ενεργοποιητής του RGB Led (neopixel) υποστηρίζεται ήδη από βιβλιοθήκες ενσωματωμένες στο Mind+. Με το πρόσθετο αυτό όμως αρκεί να γίνει μια μόνο ενσωμάτωση ώστε να λειτουργούν όσο το δυνατόν περισσότεροι αισθητήρες και ενεργοποιητές του κιτ.

---------------------------------------------------------

## Τι είναι το Polytech R2

Το R2 είναι ένα κιτ ρομποτικής της εταιρίας Polytech με έδρα τη Λάρισα. Το κιτ απαιτεί μια πολύ εύκολη και γρήγορη συναρμολόγηση. Όταν ολοκληρωθεί δημιουργείται ένα ωραίο και στιβαρό όχημα. 

Τα κιτ αυτό προορίζονται, σύμφωνα με την εταιρία, για μαθητές όλων των τάξεων του Δημοτικού Σχολείου.

Aγοράστηκαν μαζικά από το Υπουργείο Παιδείας και διανεμήθηκαν στα Δημοτικά Σχολεία της χώρας (03/2024)

---------------------------------------------------------

## Έτοιμο έργο Mind+ με ενσωματωμένο το πρόσθετο R2

Για να κατεβάσεις το αρχείο, κάνε κλικ στην παρακάτω εικόνα:

[![](./images/mind+R2.png)](https://mega.nz/file/4YQyWaaA#ej9KQiwQfaYNkw88ok5XR5RCwp8HVU0pbAz0ANTLs6g)

---------------------------------------------------------


## Changelog ##

**2025.04.27** - Προσθήκη νέων οδηγιών αλλαγής ονόματος bluetooth του κιτ R2 [εδώ](./bluetooth_rename.md)

**2025.02.23** - Προσθήκη επιλογής φωτεινότητας στο block του neopixel led. Η default τιμή είναι 50

**2025.01.25** - Προσθήκη Arduino σεναρίου (ino) το οποίο σε συνδυασμό με την Android εφαρμογή RemoteXY επιτρέπει τον τηλεχειρισμό του R2 μέσω bluetooth. Αναλυτικός οδηγός [εδώ](https://ale3andro.gr/blog/2025/01/25/%cf%84%ce%b7%ce%bb%ce%b5%cf%87%ce%b5%ce%b9%cf%81%ce%b9%cf%83%ce%bc%cf%8c%cf%82-r2-%ce%bc%ce%b5-bluetooth-%ce%ba%ce%b1%ce%b9-%ce%b5%cf%86%ce%b1%cf%81%ce%bc%ce%bf%ce%b3%ce%ae-android/)

**2025.01.07** - Αλλαγή της άδειας από ΜΙΤ σε Creative Commons Attribution-ShareAlike 4.0 International

**2024.12.22** - Αλλαγή του εικονιδίου featured.png

**2024.12.16** - Έκδοση 0.4 - Αφαίρεση του κομματιού **Ενεργοποίηση κινητήρων**, απλοποίηση κομματιών που ελέγχουν την κίνηση του αυτοκινήτου με προσθήκη κουμπιών (0) κινήσου προς τα μπροστά με ταχύτητα ..., (1) κινήσου προς τα πίσω με ταχύτητα ..., (3) στρίψε δεξιά για ... δευτερόλεπτα, (4) στρίψε αριστερά για ... δευτερόλεπτα και (5) σταμάτησε. Για περισσότερες λεπτομέρειες [εδώ](https://ale3andro.gr/blog/2024/12/17/%ce%b5%ce%bd%ce%b7%ce%bc%ce%ad%cf%81%cf%89%cf%83%ce%b7-%cf%80%cf%81%cf%8c%cf%83%ce%b8%ce%b5%cf%84%ce%bf%cf%85-mind-%ce%b3%ce%b9%ce%b1-%cf%84%ce%bf-%cf%81%ce%bf%ce%bc%cf%80%cf%8c%cf%84-r2/)

**2024.12.11** - Προστέθηκαν οι σελίδες [χρήσιμες πληροφοριές](./useful.md) και [ενδεικτικά σενάρια](./endeiktika_senaria.md)

**2024.11.24** - Προσθήκη νέου πλακιδίου εντολής "Στείλε στο monitor app το .." το οποίο στέλνει μια τιμή (πχ αισθητήρα) στο software monitor της εφαρμογής [alx_arduino_monitor](https://github.com/ale3andro/alx_arduino_monitor)

**2024.11.18** - Αλλαγή λεκτικού στο κομμάτι του Neopixel led. Αφαίρεση της λέξης **άναψε** (που είναι ασαφές για τους μαθητές λόγω του άναψε και σβήσε που χρησιμοποιείται στο πλακίδιο του τυπικού led).

**2024.11.01** - Προσθήκη οδηγιών για αλλαγή ονόματος Bluetooth Dongle από BT24 σε κάτι που έχει περισσότερο νόημα.

**2024.10.31** - Μετάφραση για τις μουσικές νότες του buzzer: από την Αγγλική σήμανση (C, D, E etc) σε Ελληνική (Ντο, Ρε, Μι κλπ)

**2024.10.03** - Προσθήκη συνδέσμου thingiverse, για το μοντέλο από το οποίο μπορούν να τυπωθούν επιπλέον βάσεις (τύπου lego) για αισθητήρες και ενεργοποιητές του κιτ.

**2024.09.29** - Προσθήκη επεξέγησης σύμβασης για χαρακτηρισμό αισθητήρων, τροχών κλπ

**2024.05.26** - Αλλαγές - διορθώσεις που πρότεινε ο Βασίλης Ανδρουτσόπουλος.

**2024.05.17** - **Έκδοση 0.1** - Καθάρισμα κώδικα από μη χρησιμοποιούμενα κομμάτια.

---------------------------------------------------------

## Θέλω να μάθω περισσότερα γι' αυτό το πρόσθετο.

Περισσότερες πληροφορίες, θα βρεις [εδώ](./useful.md)

---------------------------------------------------------

## Ενδεικτικά σενάρια χρήσης

Ενδεικτικά σενάρια χρήσης για το R2 θα βρεις [εδώ](./endeiktika_senaria.md)

---------------------------------------------------------

## Άλλα διαθέσιμα Mind+ πρόσθετα για κιτ Ρομποτικής Πρωτοβάθμιας

[Mind+ offline extension για Polytech S1](https://gitlab.com/ale3andro/mindplus_ext_s1)

[Mind+ offline extension για Microbit GigoRobot](https://github.com/ale3andro/mindplus_ext_gigorobot)

[Mind+ offline extension για Otto Robot](https://gitlab.com/ale3andro/mindplus_ext_otto)

---------------------------------------------------------

## Πίνακας με υποστηριζόμενους αισθητήρες / ενεργοποιητές του κιτ

| Αισθητήρες / Ενεργοποιητές | Κατάσταση υποστήριξης | Σχόλια |
| --- | --- | --- |
| Αισθητήρας απόστασης (υπερύθρων τύπου HC-SR04) | **Υποστηρίζεται** | Βιβλιοθήκη DFRobot_URM10 | 
| Αισθητήρας παρακολούθησης γραμμής (αντανάκλασης) | **Υποστηρίζεται** | Πρόκειται για 3 σε 1 αισθητήρα. |
| Μονάδα Bluetooth - (BT-24) | Δεν υποστηρίζεται (ακόμη) | Υπάρχουν οδηγίες αλλαγής bluetooth ονόματος για ευκολότερη σύνδεση στο Android app του κιτ [εδώ](https://ale3andro.gr/blog/2024/11/01/%ce%b1%ce%bb%ce%bb%ce%b1%ce%b3%ce%ae-%ce%bf%ce%bd%cf%8c%ce%bc%ce%b1%cf%84%ce%bf%cf%82-bluetooth-%cf%83%cf%84%ce%bf-polytech-r2/) |
| Πλακέτα ελέγχου κινητήρων οχήματων | **Υποστηρίζεται** | Βασίζεται στο TB6612FNG. Χρήση της βιβλιοθήκης TB6612FNG.h |
| Λευκό Led | **Υποστηρίζεται** | --- |
| Αισθητήρας κουμπί αφής | **Υποστηρίζεται** | --- |
| Αισθητήρας αναλογικό ήχου (μικρόφωνο) | **Υποστηρίζεται** | Πιθανόν να χρειάζεται ρύθμιση το ποτενσιόμετρο (βρίσκεται πάνω στον αισθητήρα) με ένα μικρό κατσαβίδι |
| Αισθητήρας φωτοαντίστασης (για μέτρηση επιπέδου φωτός) | **Υποστηρίζεται** | --- |
| Τετραπλό RGB Led | **Υποστηρίζεται** | Είναι τύπου Neopixel. Χρήση βιβλιοθήκης Adafruit_NeoPixel.h |
| Πλακέτα επέκτασης για σύνδεση αισθητήρων - ενεργοποιητών με interface των 3 pins & Micro servo 9g | **Υποστηρίζεται** | Χρήση βιβλιοθήκης DFRobot_Servo.h |

---------------------------------------------------------

## Ελεγκτής 

Η εταιρία δεν δίνει πολλές πληροφορίες για τον ελεγκτή αυτού του κιτ. Το μόνο σίγουρο είναι πρόκεται, όπως και το S1, για μια πλακέτα που βασίζεται στο Arduino Uno. Αναγνωρίζεται ως Arduino Uno από όλες τις εφαρμογές που μπορεί να χρησιμοποιήσει κάποιος για να προγραμματίσει το Arduino. Παρακάτω αντιγράφω την περιγραφή από το επίσημο manual της εταιρίας:

Η εταιρία το ονομάζει Robot 2 και δίνει τις παρακάτω προδιαγραφές:

1) Εξωτερική περιοχή τροφοδοσίας: 7-12V

2) Εύρος ρεύματος: ελάχιστο 800mA

3) Ταχύτητα κινητήρα: 6.0V 100 rpm/min

4) Ο έλεγχος κινητήρα πραγματοποιείται από το TB6612.

5) Τρεις ομάδες μονάδων παρακολούθησης γραμμής, για την ανίχνευση της ασπρόμαυρης γραμμής με μεγαλύτερη ακρίβεια και μπορούν επίσης να χρησιμοποιηθούν για έλεγχο κατά της πτώσης. 

6) Η μονάδα υπέρηχων χρησιμοποιείται για την ανίχνευση της απόστασης εμποδίου, αποφεύγοντας το μπροστινό εμπόδιο, όταν η απόσταση που ανιχνεύεται είναι μικρότερη από μια ορισμένη τιμή.

7) Η ασύρματη μονάδα Bluetooth μπορεί να συζευχθεί με συσκευή Bluetooth στο κινητό τηλέφωνο για τον απομακρυσμένο έλεγχο του ROBOT 2. Απενεργοποιήστε το  Bluetooth κατά τον προγραμματισμό.

8) Η ασπίδα έχει δύο σέρβο διασυνδέσεις.

9) Μπορεί να έχει πρόσβαση σε εξωτερική τάση 7~12V.

![Ο ελεγκτής του R2](board.png)

## Τι περιέχει το κουτί του R2

Το κουτί του S1 περιέχει τα παρακάτω:

- Τον ελεγκτή (πλακέτα τύπου Arduino)

- Αισθητήρας υπέρηχων 

- Αισθητήρας παρακολούθησης γραμμής (πρόκεται για τριπλό αισθητήρα 3 σε 1)

- Μονάδα Bluetooth - (BT-24)

- 2 x κινητήρες τύπου ΤΤ DC

- Λευκό Led 

- Αισθητήρα κουμπί αφής

- Αισθητήρα αναλογικό ήχου (μικρόφωνο)

- Αναλογικό αισθητήρα φωτοαντίστασης (για μέτρηση επιπέδου φωτός)

- Τετραπλό RGB Led τύπου Neopixel

- Πλακέτα επέκτασης για σύνδεση αισθητήρων - ενεργοποιητών με interface των 3 pins 

- Micro servo 9g

- Μικρό σταυροκατσάβιδο 3.0x40mm για τη συναρμολόγηση

- Πλακέτα κατασκευών τύπου Lego (συμβατή με Lego) διαστάσεων 12x6

- 2 τουβλάκια τύπου Lego (συμβατά με Lego) διαστάσεων 4x1 με ειδικές οπές για στήριξη των πλακετών των αισθητήρων και ενεργοποιητών

- Βίδες, παξιμάδια και αποστάτες αρκετά περισσότερα από αυτά που χρειάζονται για τη συναρμολόγηση.

Σημείωση: Ορισμένα από τα παραπάνω περιεχόμενα του κουτιού R2, δεν αναγράφονται στο συνοδευτικό pdf που μου έστειλε η εταιρία όταν ζήτησα το ηλεκτρονικό υλικό

## License

Creative Commons Attribution Share Alike 4.0 International

